Attribute VB_Name = "Module1"
Public nod, Dev As Long
Public serial, version As String


Type USMCMode
    PMode As Long       'Turn off buttons (TRUE - buttons disabled)
    PReg As Long        'Current reduction regime (TRUE - regime is on)
    ResetD As Long      'Turn power off and make a whole step (TRUE - apply)
    EmReset As Long     'Quick power off
    Tr1T As Long        'Trailer 1 TRUE state (TRUE : +3/+5; FALSE : 0)
    Tr2T As Long        'Trailer 2 TRUE state (TRUE : +3/+5; FALSE : 0)
    RotTrT As Long      'Rotary Transducer TRUE state (TRUE : +3/+5; FALSE : 0)
    TrSwap As Long      'If TRUE, Trailers are treated to be swapped
    Tr1En As Long       'If TRUE Trailer 1 Operation Enabled
    Tr2En As Long       'If TRUE Trailer 2 Operation Enabled
    RotTeEn As Long     'If TRUE Rotary Transducer Operation Enabled
    RotTrOp As Long     'Rotary Transducer Operation Select (stop on error for TRUE)
    Butt1T As Long      'Button 1 TRUE state (TRUE : +3/+5; FALSE : 0)
    Butt2T As Long      'Button 2 TRUE state (TRUE : +3/+5; FALSE : 0)
    ResetRT As Long     'Reset Rotary Transducer Check Positions (need one full revolution before it can detect error)
    SyncOUTEn As Long   'If TRUE output syncronization enabled
    SyncOUTR As Long    'If TRUE output synchronization counter will be reset
    SyncINOp As Long    'Synchronization input mode:
                        'True - Step motor will move one time to the destination position
                        'False - Step motor will move multiple times by steps equal to the value destination position
    SyncCount As Long   'Number of steps after which synchronization output sygnal occures
    SyncInvert As Long  'Set to TRUE to invert output synchronization signal
    'new
    EncoderEn As Long   'Enable Encoder on pins {SYNCIN,ROTTR} - disables Synchronization input and Rotary Transducer
    EncoderInv As Long  'Invert Encoder Counter Direction
    ResBEnc As Long     'Reset <Encoder Position> and <SM Position in Encoder units> to 0
    ResEnc As Long      'Reset <SM Position in Encoder units> to <Encoder Position>
    Rsv1 As Long
    Rsv2 As Long
End Type

Type USMCParameters
    AccelT As Single        'Acceleration time (in ms)
    DecelT As Single        'Deceleration time (in ms)
    PTimeout As Single      'Time (in ms) after which current will be reduced to 60% of normal
    BTimeout1 As Single     'Time (in ms) after which speed of step motor rotation will be equal to the one specified at
                            'BTO1P field (see below). (This parameter is used when controlling step motor using buttons)
    BTimeout2 As Single     '
    BTimeout3 As Single     '
    BTimeout4 As Single     '
    BTimeoutR As Single     'Time (in ms) after which reset command will be performed
    BTimeoutD As Single     'This field is reserved for future use
    MinP As Single          'Speed (steps/sec) while performing reset operation. (This parameter is used when controlling
                            'step motor using buttons)
    BTO1P As Single         'Speed (steps/sec) after BTIMEOUT 1 time have passed. (This parameter is used when controlling
                            'step motor using buttons)
    BTO2P As Single         '
    BTO3P As Single         '
    BTO4P As Single         '
    MaxLoft As Integer      'Value in full steps that will be used performing backlash operation
    StartPos As Long        'This field is reserved for future use
    RTDelta As Integer      'Revolution distance  number of full steps per one full revolution
    RTMinErr As Integer     'Number of full steps missed to raise the error flag
    MaxTemp As Single       'Maximum allowed temperature (Celsius)
    SynOUTP As Byte         'Duration of the output synchronization pulse
    LoftPeriod As Single    'Speed of the last phase of the backlash operation.
    'new
    EncMult As Single       'Should be <Encoder Steps per Evolution> / <SM Steps per Evolution> and should be integer multiplied by 0.25
    Rsv1 As Long
    Rsv2 As Long
    Rsv3 As Long
    Rsv4 As Long
End Type

Type USMCStartParameters
    SDivisor As Byte    'Step is divided by this factor (1,2,4,8)
    DefDir As Long      'Direction for backlash operation (relative)
    LoftEn As Long      'Enable automatic backlash operation (works if slow start/stop mode is off)
    SlStart As Long     'If TRUE slow start/stop mode enabled.
    WSyncIN As Long     'If TRUE controller will wait for input synchronization signal to start
    SyncOUTR As Long    'If TRUE output synchronization counter will be reset
    ForceLoft As Long   'If TRUE and destination position is equal to the current position backlash operation will be performed.
    'new
    Rsv As Long
End Type

Type USMCState
    CurPos As Long      'Current position (in microsteps)
    Temp As Single      'Current temperature of the driver
    SDivisor As Byte    'Step is divided by this factor
    Loft As Long        'Indicates backlash status
    FullPower As Long   'If TRUE then full power.
    CW_CCW As Long      'Current direction. Relatively!
    Power As Long       'If TRUE then Step Motor is ON.
    FullSpeed As Long   'If TRUE then full speed. Valid in "Slow Start" mode only.
    AReset As Long      'TRUE After Device reset, FALSE after "Set Position".
    RUN As Long         'Indicates if step motor is rotating
    SyncIN As Long      'Logical state directly from input synchronization PIN
    SyncOUT As Long     'Logical state directly from output synchronization PIN
    RotTr As Long       'Indicates current rotary transducer press state
    RotTrErr As Long    'Indicates rotary transducer error flag
    EmReset As Long     'Indicates state of emergency disable button (local control)
    Trailer1 As Long    'Indicates trailer 1 logical state.
    Trailer2 As Long    'Indicates trailer 2 logical state.
    Voltage As Single   'Input power source voltage (6-39V) -=24 version 0nly=-
    'new
    Rsv1 As Long
    Rsv2 As Long
    
End Type

Declare Sub USMCGetLastErr Lib "USMCVBDLL.dll" _
    Alias "_USMCVB_GetLastErr" (ByVal ErrStr As String, ByVal vlen As Long)

Declare Function USMCInit Lib "USMCVBDLL.dll" _
    Alias "_USMCVB_Init" (ByRef value As Long, ByVal versions As String, _
    ByVal vlen As Long, ByVal serials As String, ByVal slen As Long) As Long
    
Declare Function USMCGetState Lib "USMCVBDLL.dll" _
    Alias "_USMCVB_GetState" (ByVal Dev As Long, ByRef Str As USMCState) As Long

Declare Function USMCGetStartParameters Lib "USMCVBDLL.dll" _
    Alias "_USMCVB_GetStartParameters" (ByVal Dev As Long, ByRef Str As USMCStartParameters) As Long
    
Declare Function USMCStart Lib "USMCVBDLL.dll" _
    Alias "_USMCVB_Start" (ByVal Dev As Long, ByVal DestPos As Long, ByRef Speed As Single, _
                              ByRef Str As USMCStartParameters) As Long

Declare Function USMCStop Lib "USMCVBDLL.dll" _
    Alias "_USMCVB_Stop" (ByVal Dev As Long) As Long

Declare Function USMCGetMode Lib "USMCVBDLL.dll" _
    Alias "_USMCVB_GetMode" (ByVal Dev As Long, ByRef Str As USMCMode) As Long
    
Declare Function USMCSetMode Lib "USMCVBDLL.dll" _
    Alias "_USMCVB_SetMode" (ByVal Dev As Long, ByRef Str As USMCMode) As Long

Declare Function USMCGetParameters Lib "USMCVBDLL.dll" _
    Alias "_USMCVB_GetParameters" (ByVal Dev As Long, ByRef Str As USMCParameters) As Long
    
Declare Function USMCSetParameters Lib "USMCVBDLL.dll" _
    Alias "_USMCVB_SetParameters" (ByVal Dev As Long, ByRef Str As USMCParameters) As Long

Declare Function USMCSaveParametersToFlash Lib "USMCVBDLL.dll" _
    Alias "_USMCVB_SaveParametersToFlash" (ByVal Dev As Long) As Long
    
Declare Function USMCSetCurrentPosition Lib "USMCVBDLL.dll" _
    Alias "_USMCVB_SetCurrentPosition" (ByVal Dev As Long, ByRef Str As USMCParameters) As Long
    


Sub PrintDMode(mode As USMCMode)
    Dim out As String
    out = "Mode parameters:" & (Chr(13))
    out = out & "Buttons - "
    If mode.PMode <> 0 Then
        out = out & "Disabled" & (Chr(13))
    Else
        out = out & "Enabled" & (Chr(13)) & "Button 1 TRUE state - "
        If mode.Butt1T <> 0 Then
            out = out & "+3/+5 V" & (Chr(13))
        Else
            out = out & "0 V(GND)" & (Chr(13))
        End If
        out = out & "Button 2 TRUE state - "
        If mode.Butt2T <> 0 Then
            out = out & "+3/+5 V" & (Chr(13))
        Else
            out = out & "0 V(GND)" & (Chr(13))
        End If
    End If
    out = out & "Current reduction regime - "
    If mode.PReg <> 0 Then
        out = out & "Used" & (Chr(13))
    Else
        out = out & "Not Used" & (Chr(13))
    End If
    
    If mode.ResetD <> 0 Then
        out = out & "Power - "
        If mode.EmReset <> 0 Then
            out = out & "Emerjency Off" & (Chr(13))
        Else
            out = out & "Off" & (Chr(13))
        End If
    Else
        out = out & "Power - On" & (Chr(13))
    End If
    If mode.Tr1En <> 0 Or mode.Tr2En <> 0 Then
        out = out & "Trailers are - "
        If mode.TrSwap <> 0 Then
            out = out & "Swapped" & (Chr(13))
        Else
            out = out & "Direct" & (Chr(13))
        End If
    End If
    out = out & "Trailer 1 - "
    If mode.Tr1En <> 0 Then
        out = out & "Enabled" & (Chr(13)) & "Trailer 1 TRUE state - "
        If mode.Tr1T <> 0 Then
            out = out & "+3/+5 V" & (Chr(13))
        Else
            out = out & "0 V(GND)" & (Chr(13))
        End If
    Else
        out = out & "Disabled" & (Chr(13))
    End If
    out = out & "Trailer 2 - "
    If mode.Tr2En <> 0 Then
        out = out & "Enabled" & (Chr(13)) & "Trailer 2 TRUE state - "
        If mode.Tr2T <> 0 Then
            out = out & "+3/+5 V" & (Chr(13))
        Else
            out = out & "0 V(GND)" & (Chr(13))
        End If
    Else
        out = out & "Disabled" & (Chr(13))
    End If
    out = out & "Rotary Transducer - "
    If mode.RotTeEn <> 0 Then
        out = out & "Enabled" & (Chr(13)) & "Rotary Transducer TRUE state - "
        If mode.RotTrT <> 0 Then
            out = out & "+3/+5 V" & (Chr(13))
        Else
            out = out & "0 V(GND)" & (Chr(13))
        End If
        out = out & "Rotary Transducer Operation - "
        If mode.RotTrOp <> 0 Then
            out = out & "Stop on error" & (Chr(13))
        Else
            out = out & "Check and ignore error" & (Chr(13))
        End If
        out = out & "Reset Rotary Transducer Check Positions - "
        If mode.ResetRT <> 0 Then
            out = out & "Initiated" & (Chr(13))
        Else
            out = out & "No, why?" & (Chr(13))
        End If
    Else
        out = out & "Disabled" & (Chr(13))
    End If
    out = out & "Output Syncronization - "
    If mode.SyncOUTEn <> 0 Then
        out = out & "Enabled" & (Chr(13)) & "Reset Output Synchronization Counter - "
        If mode.SyncOUTR <> 0 Then
            out = out & "Initiated" & (Chr(13))
        Else
            out = out & "No, why?" & (Chr(13))
        End If
        out = out & "Number of steps after which synchronization output sygnal occures - " & mode.SyncCount & (Chr(13))
    Else
        out = out & "Disabled" & (Chr(13))
    End If
    out = out & "Synchronization input mode:" & (Chr(13))
    If mode.SyncINOp <> 0 Then
        out = out & "Step motor will move one time to the destination position" & (Chr(13))
    Else
        out = out & "Step motor will move multiple times by [destination position]" & (Chr(13))
    End If
    out = out & "Synchronization Output - "
    If mode.SyncInvert <> 0 Then
        out = out & "INVERTED" & (Chr(13))
    Else
        out = out & "NORMAL" & (Chr(13))
    End If
    MsgBox out, vbOKOnly, "USMC_SetMode Successful"
End Sub

Sub PrintDState(state As USMCState)
Dim out As String
With state
    out = "The state is:" & (Chr(13))
    out = out & "- Current Position in microsteps - " & Format(.CurPos) & (Chr(13))
    out = out & "- Temperature - " & Format(.Temp, "0.00") & (Chr(176)) & (Chr(67)) & (Chr(13))
    out = out & "- Step Divisor - " & Format(.SDivisor, "0") & (Chr(13))
    out = out & "- Loft State - "
    If .Loft <> 0 Then
        out = out & "Indefinite" & (Chr(13))
    Else
        out = out & "Fixed" & (Chr(13))
    End If
    out = out & "- Power - "
    If .Power <> 0 Then
        If .FullPower <> 0 Then
            out = out & "Full" & (Chr(13))
        Else
            out = out & "Half" & (Chr(13))
        End If
    Else
        out = out & "Off" & (Chr(13))
    End If
    If .RUN <> 0 Then
        out = out & "- Step Motor is Running in "
        If .CW_CCW <> 0 Then
            out = out & "CCW Direction "
        Else
            out = out & "CW Direction "
        End If
        If (.SDivisor = 1) And (.FullSpeed <> 0) Then
            out = out & "at Full Speed" & (Chr(13))
        Else
            out = out & (Chr(13))
        End If
    Else
        out = out & "- Step Motor is Not Running" & (Chr(13))
    End If
    out = out & "- Device "
    If .AReset <> 0 Then
        out = out & "is After Reset" & (Chr(13))
    Else
        out = out & "Position Already Set" & (Chr(13))
    End If
    out = out & "- Input Synchronization Logical Pin State - "
    If .SyncIN <> 0 Then
        out = out & "TRUE" & (Chr(13))
    Else
        out = out & "FALSE" & (Chr(13))
    End If
    out = out & "- Output Synchronization Logical Pin State - "
    If .SyncOUT <> 0 Then
        out = out & "TRUE" & (Chr(13))
    Else
        out = out & "FALSE" & (Chr(13))
    End If
    out = out & "- Rotary Transducer Logical Pin State - "
    If .RotTr <> 0 Then
        out = out & "TRUE" & (Chr(13))
    Else
        out = out & "FALSE" & (Chr(13))
    End If
    out = out & "- Rotary Transducer Error Flag - "
    If .RotTrErr <> 0 Then
        out = out & "Error" & (Chr(13))
    Else
        out = out & "Clear" & (Chr(13))
    End If
    out = out & "- Emergency Disable Button - "
    If .EmReset <> 0 Then
        out = out & "Pushed" & (Chr(13))
    Else
        out = out & "Unpushed" & (Chr(13))
    End If
    out = out & "- Trailer 1 Press State - "
    If .Trailer1 <> 0 Then
        out = out & "Pushed" & (Chr(13))
    Else
        out = out & "Unpushed" & (Chr(13))
    End If
    out = out & "- Trailer 2 Press State - "
    If .Trailer2 <> 0 Then
        out = out & "Pushed" & (Chr(13))
    Else
        out = out & "Unpushed" & (Chr(13))
    End If
    out = out & "- Input Voltage - "
    If .Voltage = 0 Then
        out = out & "Low" & (Chr(13))
    Else
        out = out & Format(.Voltage, "0.0") & (Chr(13))
    End If
    MsgBox out, vbOKOnly, "USMC_GetState Successful"
End With
End Sub

Sub PrintError()
    Dim out As String
    out = String(1000, 0)
    USMCGetLastErr out, 1000
    MsgBox out, vbOKOnly, "Error"
End Sub

Sub PrintDStartParameters(DPos As Long, Speed As Single, sp As USMCStartParameters)
With sp
    Dim out As String
    out = "Destination position - " & Format(DPos) & (Chr(13))
    out = out & "Speed - " & Format(Speed, "##.00") & " tacts/s" & (Chr(13))
    out = out & "Steps Divisor - " & Format(.SDivisor, "0") & (Chr(13))
    If .SDivisor = 1 Then
        out = out & "Slow start/stop mode - "
        If .SlStart <> 0 Then
            out = out & "Enabled" & (Chr(13))
        Else
            out = out & "Disabled" & (Chr(13))
        End If
    Else
        out = out & "Automatic backlash operation - "
        If .LoftEn <> 0 Then
            out = out & "Enabled" & (Chr(13))
            out = out & "Automatic backlash operation direction - "
            If .DefDir <> 0 Then
                out = out & "CCW" & (Chr(13))
            Else
                out = out & "CW" & (Chr(13))
            End If
            out = out & "Force automatic backlash operation - "
            If .ForceLoft <> 0 Then
                out = out & "TRUE" & (Chr(13))
            Else
                out = out & "FALSE" & (Chr(13))
            End If
        Else
            out = out & "Disabled" & (Chr(13))
        End If
    End If
    If .WSyncIN <> 0 Then
        out = out & "Controller will wait for input synchronization signal to start" & (Chr(13))
    Else
        out = out & "Input synchronization signal ignored" & (Chr(13))
    End If
    If .SyncOUTR <> 0 Then
        out = out & "Output synchronization counter will be reset" & (Chr(13))
    Else
        out = out & "Output synchronization counter will not be reset" & (Chr(13))
    End If
    
    MsgBox out, vbOKOnly, "USMC_Start Successful"

End With
End Sub

Sub PrintDParameters(Parameters As USMCParameters)
With Parameters
    Dim out As String
    out = "The parameters are:" & (Chr(13))
    out = out & "Full acceleration time - " & Format(.AccelT, "###0") & " ms" & (Chr(13))
    out = out & "Full deceleration time - " & Format(.DecelT, "###0") & " ms" & (Chr(13))
    out = out & "Power reduction timeout - " & Format(.PTimeout, "###0") & " ms" & (Chr(13))
    out = out & "Button speedup timeout 1 - " & Format(.BTimeout1, "###0") & " ms" & (Chr(13))
    out = out & "Button speed after timeout 1 - " & Format(.BTO1P, "###0.00") & " steps/s" & (Chr(13))
    out = out & "Button speedup timeout 2 - " & Format(.BTimeout2, "###0") & " ms" & (Chr(13))
    out = out & "Button speed after timeout 2 - " & Format(.BTO2P, "###0.00") & " steps/s" & (Chr(13))
    out = out & "Button speedup timeout 3 - " & Format(.BTimeout3, "###0") & " ms" & (Chr(13))
    out = out & "Button speed after timeout 3 - " & Format(.BTO3P, "###0.00") & " steps/s" & (Chr(13))
    out = out & "Button speedup timeout 4 - " & Format(.BTimeout4, "###0") & " ms" & (Chr(13))
    out = out & "Button speed after timeout 4 - " & Format(.BTO4P, "###0.00") & " steps/s" & (Chr(13))
    out = out & "Button reset timeout - " & Format(.BTimeoutR, "###0") & " ms" & (Chr(13))
    out = out & "Button reset operation speed - " & Format(.MinP, "###0.00") & " steps/s" & (Chr(13))
    out = out & "Backlash operation distance - " & Format(.MaxLoft) & " steps" & (Chr(13))
    out = out & "Revolution distance - " & Format(.RTDelta) & " steps" & (Chr(13))
    out = out & "Minimal revolution distance error - " & Format(.RTMinErr) & " steps" & (Chr(13))
    out = out & "Power off temperature - " & Format(.MaxTemp, "##0.00") & (Chr(176)) & (Chr(67)) & (Chr(13))
    out = out & "Duration of the output synchronization pulse - "
    If .SynOUTP = 0 Then
       out = out & "minimal" & (Chr(13))
    Else
       out = out & Format(.SynOUTP - 0.5, "##0.0") & " * [Tact Period]" & (Chr(13))
    End If
    out = out & "Speed of the last phase of the backlash operation - "
    If .LoftPeriod = 0 Then
       out = out & "normal" & (Chr(13))
    Else
       out = out & Format(.LoftPeriod - 0.5, "###0.00") & " steps/s" & (Chr(13))
    End If
    MsgBox out, vbOKOnly, "USMC_SetParameters Successful"

End With
End Sub
